unit TextLog;
{ prce s logem implementovanm jako textov soubor }
{ ir 070423 - vytvoeno }

{----------------------------------------------------------------------}

interface

procedure ResetLog; { oteve log pro ten }
procedure RewriteLog; { oteve log pro psan }
procedure CloseLog; { zave log }
function  ReadLog: String; { pete jeden zznam z logu }
procedure WriteLog(nest: Integer; procname, msg: String); { zape jeden zznam do logu }
function  EofLog: Boolean; { true pi dosaen konce logu, jinak false }

{----------------------------------------------------------------------}

implementation
uses SysUtils;

const
  LogFN = 'logfile.txt'; { jmno logovacho souboru }
var
  OrdNr: Integer; { poadov slo zznamu v logu }
  LogFile: Text;

{ oteve log pro ten }
procedure ResetLog;
begin
  AssignFile(LogFile, LogFN);
  Reset(LogFile);
end {ResetLog};

{ oteve log pro psan }
procedure RewriteLog;
begin
  AssignFile(LogFile, LogFN);
  Rewrite(LogFile);
  OrdNr := 0;
end {RewriteLog};

{ zave log }
procedure CloseLog;
begin
  CloseFile(LogFile);
end {CloseLog};

{
  el:
    pete jeden zznam z logu
  vrac:
    obsah jednoho zznamu zformtovan do znakovho etzce
}
function ReadLog: String;
begin
  Readln(LogFile, Result);
end {ReadLog};

{
  el:
    zape jeden zznam do logu
  parametry:
    nest     - rove vnoen volajc rutiny
    procname - jmno volajc rutiny
    msg      - zprva, kter m bt zapsna do logu
}
procedure WriteLog(nest: Integer; procname, msg: String);
begin
  Inc(OrdNr);
  Writeln(LogFile, OrdNr:4, '. | ', DateTimeToStr(Now), ' | ', 'nest=', nest:4, ' | ', procname:16, msg:21);
  Flush(LogFile); { ulo na disk pro ppad zhroucen programu }
end {WriteLog};

{
  el:
    indikuje konec logu
  vrac:
    true pi dosaen konce logu, jinak false
}
function  EofLog: Boolean;
begin
  EofLog := Eof(LogFile);
end {EofLog};

end {TextLog}.
