unit UForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    ebfs: TEdit;
    btnfs: TButton;
    Label6: TLabel;
    Label7: TLabel;
    ebfi: TEdit;
    btnfi: TButton;
    ebfr: TEdit;
    btnfr: TButton;
    ebfb: TEdit;
    btnfb: TButton;
    ebfa: TEdit;
    ebvs: TEdit;
    btnvs: TButton;
    ebvi: TEdit;
    ebvr: TEdit;
    ebvb: TEdit;
    ebva: TEdit;
    btnvi: TButton;
    btnvr: TButton;
    btnvb: TButton;
    procedure btnvbClick(Sender: TObject);
    procedure btnfbClick(Sender: TObject);
    procedure btnvrClick(Sender: TObject);
    procedure btnfrClick(Sender: TObject);
    procedure btnviClick(Sender: TObject);
    procedure btnfiClick(Sender: TObject);
    procedure btnvsClick(Sender: TObject);
    procedure btnfsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

type

  TByteArray = array [0..9] of Byte;

  { typ zznamu s variantn st }
  TVarRec = record
    { pevn st - kad poloka m sv msto v pamti }
    fs: String[9];
    fi: Integer;
    fr: Real;
    fb: Boolean;
    fa: TByteArray;
    case Byte of
      { variantn st - poloky sdlej spolen msto v pamti }
      0: (vs: String[9]);
      1: (vi: Integer);
      2: (vr: Real);
      3: (vb: Boolean);
      4: (va: TByteArray)
  end {TVarRec};

var vr: TVarRec;

{ konvertuje pole bajt na etzec estnctkovch slic }
function ByteArrayToStr(ba: TByteArray): String;
var i: Integer;
begin
  for i := Low(ba) to High(ba) do
    Result := Result + IntToHex(ba[i],2) + ' '
end {ByteArrayToStr};

{ zobraz poloky zznamu vr do polek ve formuli }
procedure ShowVR;
begin
  with Form1 do begin
    ebfs.Text := vr.fs;
    ebfi.Text := IntToStr(vr.fi);
    ebfr.Text := FloatToStr(vr.fr);
    ebfb.Text := BoolToStr(vr.fb, true);
    ebfa.Text := ByteArrayToStr(vr.fa);
    ebvs.Text := vr.vs;
    ebvi.Text := IntToStr(vr.vi);
    ebvr.Text := FloatToStr(vr.vr);
    ebvb.Text := BoolToStr(vr.vb, true);
    ebva.Text := ByteArrayToStr(vr.va);
  end {with};
end;

{ nsleduj obslun rutiny tlatek }

procedure TForm1.btnfsClick(Sender: TObject);
begin
  vr.fs := ebfs.Text;
  ShowVR;
end;

procedure TForm1.btnvsClick(Sender: TObject);
begin
  vr.vs := ebvs.Text;
  ShowVR;
end;

procedure TForm1.btnfiClick(Sender: TObject);
begin
  vr.fi := StrToInt(ebfi.Text);
  ShowVR;
end;

procedure TForm1.btnviClick(Sender: TObject);
begin
  vr.vi := StrToInt(ebvi.Text);
  ShowVR;
end;

procedure TForm1.btnfrClick(Sender: TObject);
begin
  vr.fr := StrToFloat(ebfr.Text);
  ShowVR;
end;

procedure TForm1.btnvrClick(Sender: TObject);
begin
  vr.vr := StrToFloat(ebvr.Text);
  ShowVR;
end;

procedure TForm1.btnfbClick(Sender: TObject);
begin
  vr.fb := StrToBool(ebfb.Text);
  ShowVR;
end;

procedure TForm1.btnvbClick(Sender: TObject);
begin
  vr.vb := StrToBool(ebvb.Text);
  ShowVR;
end;

end.
