unit UPuzzle;
{
  Obsahuje tdu TPuzzle, hraje hru Hangman.
  ir 070415
}

interface

uses Grids;

type

  { hraje hru "Hangman" }
  TPuzzle = class
  private
    crossword: array of array of Char;
    sgCrossword: TStringGrid;
  public
    constructor Create(dataName: String; aSGXword: TStringGrid);
    procedure Display;
    function Solved: Boolean;
    procedure Highlight(ch: Char);
  end {TPuzzle};

implementation

{
  el: Vytvo novou instanci tdy TPuzzle, nate data ze souboru.
  Parametry:
    dataName - jmno souboru se vstupnmi daty
    aSGXword - mka ve formuli, kam se prbn zobrazuje kovka
}
constructor TPuzzle.Create(dataName: String; aSGXword: TStringGrid);
var
  data: Text;
  n: Integer;
  i, j: Integer;
  ch: Char;
begin
  sgCrossword := aSGXword; // just a reference to an instance is assigned
  AssignFile(data, dataName);
  Reset(data);
  Readln(data, n);
  SetLength(crossword, n, n);
  sgCrossword.Height := 27 * n;
  sgCrossword.Width  := 27 * n;
  sgCrossword.ColCount := n;
  sgCrossword.RowCount := n;
  for i := Low(crossword) to High(crossword) do begin
    for j := Low(crossword) to High(crossword) do begin
      Read(data, ch);
      crossword[j,i] := ch;
      if '.' = ch
        then sgCrossword.Cells[j,i] := '.'
        else sgCrossword.Cells[j,i] := '?';
    end {for};
    Readln(data);
  end {for};
  CloseFile(data);
end {Create};

{
  el: Zobraz prbn stav lutn kovky.
}
procedure TPuzzle.Display;
begin
  sgCrossword.Refresh;
end {Display};

{
  el: Zjist, zda kovka je vylutna.
  Popis: Nenajde-li v kovce dn otaznk, jsou vechny znaky vylutn,
    a tedy i cel kovka je vylutn.
  Parametry: dn
  Vrac True, kdy kovka neobsahuje dn nevylutn znaky, jinak False
}
function TPuzzle.Solved: Boolean;
var
  known: Integer;
  n, i, j: Integer;
begin
  n := High(crossword);
  known := 0;
  for i := Low(crossword) to High(crossword) do begin
    for j := Low(crossword) to High(crossword) do begin
      if '?' <> sgCrossword.Cells[j,i] then Inc(known);
    end {for};
  end {for};
  Solved := n * n = known;
end {Solved};

{
  el: Aktualizuje stav lutn kovky.
  Popis:
    Zape do mky ve formuli zadan znak na vechna msta, kde
    se vyskytuje v pedloze.
  Parametry:
    ch - znak zadan hrem, kter se m zobrazit na sprvnch mstech
         v mce
}
procedure TPuzzle.Highlight(ch: Char);
var
  i, j: Integer;
begin
  for i := Low(crossword) to High(crossword) do begin
    for j := Low(crossword) to High(crossword) do begin
      if UpCase(crossword[j,i]) = UpCase(ch) then begin
        sgCrossword.Cells[j,i] := ch;
      end {if};
    end {for};
  end {for};
end {Highlight};

end {UPuzzle}.
