unit UStack;
// Datov struktura zsobnk (LIFO)
// Popis: implementace polem, jako tda TStack
// ir 070610 - vytvoeno

interface

type

  // Zsobnk
  // Popis: implementace zsobnku polem
  TStack = class
  protected
    table: array of String;
    depth: Integer; // index prvn voln poloky
  public
    constructor Create(maxDepth: Integer);
    function More: Boolean;
    procedure Push(value: String);
    function Pop: String;
  end {TStack};

implementation

(*********************************************************************)

// Konstruktor
// Popis:
//  nastav nejvt monou velikost zsobnku na maxDepth a vyprzdn zsobnk
// Parametr:
//  maxDepth - nejvt velikost zsobnku, vc poloek do nj neulome
constructor TStack.Create(maxDepth: Integer);
begin
  SetLength(table, maxDepth);
  depth := Low(table);
end {Create};

(*********************************************************************)

// Testuje, zda je zsobnk neprzdn
// Vrac
//  True, kdy jsou v zsobnku poloky,
//  False, kdy je zsobnk przdn.
function TStack.More: Boolean;
begin
  More := depth > 0;
end {More};

(*********************************************************************)

// Vlo novou poloku do zsobnku
// Popis:
//  z hodnoty value vytvo novou poloku a vlo ji na vrchol zsobnku
// Parametr:
//  value - hodnota nov poloky zsobnku
procedure TStack.Push(value: String);
begin
  table[depth] := value;
  Inc(depth);
end {Push};

(*********************************************************************)

// Vyjme poloku ze zsobnku
// Popis:
//  Z vrcholu zsobnku odebere poloku a vrt jej hodnotu. Odebere tu
//  poloku, kter byla pidna na zsobnk jako posledn.
// Vrac:
//  hodnotu poloky z vrcholu zsobnku
function TStack.Pop: String;
begin
  Dec(depth);
  Pop := table[depth];
end {Pop};

(*********************************************************************)

end {UStack}.
