unit UCalculator;
// Kalkultor, kter set a odt
// ir 070610

interface
uses UTraceStack;

type
  {
    Rozebr a vyhodnocuje celoseln vrazy. Vrazy te
    ze znakovho souboru. Trasuje voln funkc a pe je
    do znakovho souboru.

    Text: Expression (Expression)* EOF
    Expression: Term (Operator Term)*
    Operator: "+" | "-"
    Term: Number | "(" Expression ")"
    Number: Digit (Digit)*
  }
  TCalculator = class (TTraceStack)
    private
      InFile: Text;
      CurrChar: Char;
      procedure SkipBlanks;
    public
      constructor Create(inFileName: String);
      procedure Close;
    private
      function ParseNumber: Integer;
      function ParseTerm: Integer;
      function ParseExpression: Integer;
    public
      procedure ParseText;
  end {TCalculator};

implementation

(*********************************************************************)

// Konstruktor
// Popis: Vytvo nov przdn zsobnk o velikosti 100 poloek
constructor TCalculator.Create(inFileName: String);
begin
  inherited Create(100);
  AssignFile(InFile, inFileName);
  Reset(InFile);
end {Create};

(*********************************************************************)

// Zave soubory
procedure TCalculator.Close;
begin
  inherited Close;
  CloseFile(InFile);
end {Close};

(*********************************************************************)

// Vynech mezery, tabultory, nov dky aj. przdn znaky
procedure TCalculator.SkipBlanks;
begin
  while not Eof(InFile) and (' ' >= CurrChar) do Read(InFile, CurrChar);
end {SkipBlanks};

(*********************************************************************)

// Rozebere slo a vrt jeho hodnotu
//    Number: Digit (Digit)*
// Vrac hodnotu sla
function TCalculator.ParseNumber: Integer;
begin
  Result := 0;
  while CurrChar in ['0'..'9'] do begin
    Result := 10 * Result + Ord(CurrChar) - Ord('0');
    if Eof(InFile)
      then CurrChar := Chr(0)
      else Read(InFile, CurrChar);
  end {while};
end {ParseNumber};

(*********************************************************************)

// Rozebere len a vrt jeho hodnotu
//    Term: Number | "(" Expression ")"
// Vrac hodnotu lenu
function TCalculator.ParseTerm: Integer;
begin
  Extend('term');
  SkipBlanks;
  if CurrChar in ['0'..'9'] then begin
    // parse number
    Result := ParseNumber;
  end else begin
    // parse "("
    Assert('(' = CurrChar,' ### Chyb "(" ### ');
    Read(InFile, CurrChar);
    // parse expression
    Result := ParseExpression;
    SkipBlanks;
    // parse ")"
    Assert(')' = CurrChar,' ### Chyb ")" ### ');
    Read(InFile, CurrChar);
  end {if};
  SkipBlanks;
  Reduce(Result);
end {ParseTerm};

(*********************************************************************)

// Rozebere vraz a vrt jeho hodnotu
//    Expression: Term (Operator Term)*
//    Operator: "+" | "-"
// Vrac hodnotu vrazu
function TCalculator.ParseExpression: Integer;
begin
  Extend('expr');
  Result := ParseTerm;
  while ('+' = CurrChar) or ('-' = CurrChar) do begin
    if '+' = CurrChar then begin
      Read(InFile, CurrChar);
      Result := Result + ParseTerm;
    end else begin
      Read(InFile, CurrChar);
      Result := Result - ParseTerm;
    end {if};
  end {while};
  Reduce(Result);
end {ParseExpression};

(*********************************************************************)

// Rozebere text ze vstupnho souboru, hodnoty vraz ignoruje
//    Text: Expression (Expression)* EOF
procedure TCalculator.ParseText;
begin
  ParseExpression;
  while not Eof(InFile) do begin
    ParseExpression;
  end {while};
end {ParseText};

(*********************************************************************)

end {UCalculator}.
