unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Label2: TLabel;
    tbDay: TEdit;
    Label3: TLabel;
    tbHour: TEdit;
    Label4: TLabel;
    tbMinute: TEdit;
    Label5: TLabel;
    tbSecond: TEdit;
    Label6: TLabel;
    tbNoon: TEdit;
    Timer1: TTimer;
    cbStart: TCheckBox;
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

type
  Tday = (su, mo, tu, we, th, fr, sa, err);

var
  day: Tday;
  hour, min, sec: 0..61;
  am: Boolean;

implementation

{$R *.dfm}

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if cbStart.Checked then begin
    if tbDay.Text = 'su' then day := su
    else if tbDay.Text = 'mo' then day := mo
    else if tbDay.Text = 'tu' then day := tu
    else if tbDay.Text = 'we' then day := we
    else if tbDay.Text = 'th' then day := th
    else if tbDay.Text = 'fr' then day := fr
    else if tbDay.Text = 'sa' then day := sa
    else day := err;

    hour := StrToInt(tbHour.Text);
    min := StrToInt(tbMinute.Text);
    sec := StrToInt(tbSecond.Text);

    am := tbNoon.Text = 'am';

    case sec of
    0..58: Inc(sec);
    else
      begin
        sec := 0;
        Inc(min);
        if not (min in [0..59]) then begin
          Dec(min, 59);
          Inc(hour);
          if not (hour in [0..11]) then begin
            Dec(hour, 11);
            am := not am;
            if am then begin
              if day in [su..fr] then Inc(day) else day := su;
            end {if};
          end {if};
        end {if};
      end
    end {case};

    case day of
    su: tbDay.Text := 'Su';
    mo: tbDay.Text := 'Mo';
    tu: tbDay.Text := 'Tu';
    we: tbDay.Text := 'We';
    th: tbDay.Text := 'Th';
    fr: tbDay.Text := 'Fr';
    sa: tbDay.Text := 'Sa';
    end {case};

    tbHour.Text := IntToStr(hour);
    tbMinute.Text := IntToStr(min);
    tbSecond.Text := IntToStr(sec);

    if am then tbNoon.Text := 'am' else tbNoon.Text := 'pm';

  end {if}
end {Timer1Timer};

end {unit}.
