unit UnitMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ValEdit, StdCtrls, ExtCtrls;

type
  TFormMain = class(TForm)
    ebStudent: TEdit;
    btnFind: TButton;
    dgComputers: TDrawGrid;
    imgObsazeny: TImage;
    imgVolny: TImage;
    imgZadny: TImage;
    rgClickAction: TRadioGroup;
    rbClear: TRadioButton;
    rbShow: TRadioButton;
    procedure btnFindClick(Sender: TObject);
    procedure dgComputersDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure dgComputersClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

var
  Computers: array [1..17] of String;

{$R *.dfm}

procedure TFormMain.btnFindClick(Sender: TObject);
var
  tmp: String;
  ix, limit: Integer;
begin

  { !!! BACHA: Hansenova finta !!! }
  ix := 1; limit := High(Computers);
  while ix < limit do begin
    if ebStudent.Text = Computers[ix]
      then limit := ix
      else Inc(ix);
  end {while};
  if ebStudent.Text = Computers[ix] then begin
  { --- konec  Hansenovy  finty --- }

    tmp := Computers[ix];
    Computers[ix] := EmptyStr;
    dgComputers.Refresh;
    Sleep(500);
    Computers[ix] := tmp;
    dgComputers.Refresh;

  end else ShowMessage('Student ' + ebStudent.Text + ' nen v uebn.');
end;

procedure TFormMain.dgComputersClick(Sender: TObject);
var
  ix: Integer;
  valid: Boolean;
begin
  if 3 = dgComputers.Row then begin
    case dgComputers.Col of
    2, 3: begin
      ix := 15 + dgComputers.Col;
      valid := true;
    end else
      valid := false;
    end {case};
  end else begin
    ix := dgComputers.Row * 5 + dgComputers.Col + 1;
    valid := true;
  end {if};
  if valid then begin
    if rbShow.Checked then begin
      ebStudent.Text := Computers[ix];
    end else if EmptyStr = Computers[ix] then begin
      Computers[ix] := ebStudent.Text
    end else begin
      ebStudent.Text := EmptyStr;
      Computers[ix] := EmptyStr;
    end {if};
    dgComputers.Refresh;
  end {if};
end;

procedure TFormMain.dgComputersDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  ix: Integer;
  valid: Boolean;
begin
  if 3 = ARow then begin
    case ACol of
    2, 3: begin
      ix := 15 + ACol;
      valid := true;
    end else
      valid := false;
    end {case};
  end else begin
    ix := ARow * 5 + ACol + 1;
    valid := true;
  end {if};
  if valid then begin
    if EmptyStr = Computers[ix]
      then dgComputers.Canvas.Draw(Rect.Left, Rect.Top, imgVolny.Picture.Bitmap)
      else dgComputers.Canvas.Draw(Rect.Left, Rect.Top, imgObsazeny.Picture.Bitmap)
  end else begin
    dgComputers.Canvas.Draw(Rect.Left, Rect.Top, imgZadny.Picture.Bitmap);
  end {if};
end;

end.
