program Readability;
(*
  te anglick text a pot skre itelnosti
  zaloen na prmrnm potu slov ve vt.

  Text:
    { Sentence } EOF
  Sentence:
    Word { AnotherWord } EOS
  Word:
    Letter { Letter }
  AnotherWord:
    [ , ] Word
  EOS:
    : | ! | ? | .
*)

{$APPTYPE CONSOLE}

uses
  SysUtils;

var
  inFN: String;
  inFile, outFile: Text;
  ch: char;
  score: Integer;

  //-------------------------------------------------------------------

  procedure SkipBlanks;
  begin
    while not Eof(inFile) and (ch <= ' ') do Read(inFile, ch);
  end {};

  //-------------------------------------------------------------------

  // EOS: : | ! | ? | .
  function IsEOS: Boolean;
  begin
    IsEOS := ch in [':','!','?','.']
  end {IsEOS};

  //-------------------------------------------------------------------

  // Word: Letter { Letter }
  function ParseWord: Integer;
  begin
    while (ch in ['a'..'z', '0'..'9', 'A'..'Z']) do Read(inFile, ch);
    SkipBlanks;
    ParseWord := 1
  end {ParseWord};

  //-------------------------------------------------------------------

  // AnotherWord: [ , ] Word
  function ParseAnotherWord: Integer;
  begin
      // -- [ , ] --
      if (ch = ',') then begin
        Read(inFile, ch);
        SkipBlanks;
      end {if};
      ParseAnotherWord := ParseWord;
  end {ParseAnotherWord};

  //-------------------------------------------------------------------

  // Sentence: Word { AnotherWord } EOS
  function ParseSentence: Integer;
  var words: Integer;
  begin
    words := ParseWord;
    // -- { AnotherWord } --
    while not IsEOS do Inc(words, ParseAnotherWord);
    // -- skip EOS --
    Read(inFile, ch);
    SkipBlanks;
    ParseSentence := words
  end {ParseSentence};

  //-------------------------------------------------------------------

  // Text: { Sentence } EOF
  function ParseText: Integer;
  var sentences, words: Integer;
  begin
    if not Eof(inFile) then begin
      Read(inFile, ch);
      SkipBlanks;
    end {if};
    Assert(not Eof(inFile), '!!! Vstupn soubor je przdn !!!');
    sentences := 0; words := 0;
    // -- { Sentence } --
    while not Eof(inFile) do begin
      Inc(words, ParseSentence);
      Inc(sentences, 1);
    end {while};
    ParseText := words div sentences
  end {ParseText};

//---------------------------------------------------------------------

begin
  { TODO -oUser -cConsole Main : Insert code here }
  Write('Jmeno souboru: ');
  Readln(inFN);
  AssignFile(inFile, inFN);
  AssignFile(outFile, 'results.txt');
  Reset(inFile);
  Rewrite(outFile);

  score := ParseText;

  { Vyhodnocen: }
  Write(outFile, 'Obtnost textu odpovd ');
  if score <= 8 then Write(outFile, '4. td Z: ')
  else if score <= 11 then Write(outFile, '5. td Z: ')
  else if score <= 14 then Write(outFile, '6. td Z: ')
  else if score <= 17 then Write(outFile, '7.-9. td Z: ')
  else if score <= 24 then Write(outFile, 'stedn kole: ')
  else Write(outFile, 'vysok kole: ');
  Writeln(outFile, IntToStr(score) + ' slov ve vt.');

  CloseFile(inFile);
  CloseFile(outFile);
end {Readability}.
