unit UAssExc;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFAssExc = class(TForm)
    ebNumber: TEdit;
    Button1: TButton;
    lblResult: TLabel;
    ebName: TEdit;
    Label1: TLabel;
    ebAddress: TEdit;
    Label2: TLabel;
    Button2: TButton;
    Button3: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Button4: TButton;
    Button5: TButton;
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FAssExc: TFAssExc;

implementation

{$R *.dfm}

type
  TPersonalRecord = class
    name, IPAddr: String;
    next: TPersonalRecord;
    constructor Create(aName, anIPAddr: String);
    class procedure Insert(aName, anIPAddr: String; var list: TPersonalRecord);
  end {TPersonalRecord};

var
  Directory: TPersonalRecord;

constructor TPersonalRecord.Create(aName, anIPAddr: String);
begin
  inherited Create;
  name := aName;
  IPAddr := anIPAddr;
  next := nil;
end {Create};

class procedure TPersonalRecord.Insert(aName, anIPAddr: String; var list: TPersonalRecord);
var r: TPersonalRecord;
begin
  r := TPersonalRecord.Create(aName, anIPAddr);
  r.next := list;
  list := r;
end {Insert};

//--- obslun rutiny -------------------------------------------------------

//------------------------------------------------------------------------------
// -- oeten chyb:
procedure TFAssExc.Button1Click(Sender: TObject);
var x: Integer;
begin
  // -- chyby se v zsad odchytvat nemaj --
  // try
    x := StrToInt(ebNumber.Text);
    lblResult.Caption := IntToStr(x*3);
  // except on EConvertError do
  //   lblResult.Caption := '''' + ebNumber.Text + ''' nen slo';
  // end {try}
end;

procedure TFAssExc.Button2Click(Sender: TObject);
begin
  // vytvo a napl zznam, pidej do seznamu
  TPersonalRecord.Insert(ebName.Text, ebAddress.Text, Directory);
end;

//------------------------------------------------------------------------------
// -- oeten vjimek pomoc peddefinovanch td
procedure TFAssExc.Button3Click(Sender: TObject);
var
  cur: TPersonalRecord;
begin
  // hledej ebName.Text v seznamu
  cur := Directory;
  // -- vjimky (na rozdl od chyb) je NUTN oetit --
  try
    while cur.name <> ebName.Text do begin
      cur := cur.next;
      Assert(nil <> cur); { kdy se zakomentuje, dojde k chyb EAccessViolation }
    end {while};
    // najde - nape IP adresu do ebAddr.Text
    ebAddress.Text := cur.IPAddr;
  // nen v seznamu - vyhod a odchyt exception
  except
    on EAccessViolation do begin // vjimky odchytvm co nejspecifitji (oeten obecn tdy Exception mu zaadit a jako posledn exception handler)
      ShowMessage('Jmno ''' + ebName.Text + ''' nen v seznamu');
      ebAddress.Text := EmptyStr;
    end {on};
    on EAssertionFailed do begin
      ebAddress.Text := EmptyStr;
      ShowMessage('Jmno ''' + ebName.Text + ''' nen v seznamu');
    end {on};
    // sem me pijt obecn "on Exception" nebo "else"
  end {try};
end;

//------------------------------------------------------------------------------
// -- moje vlastn tda vjimek (li se od peddefinovanch td)
type
  ERecordNotFound = class(Exception)end;

procedure TFAssExc.Button4Click(Sender: TObject);
var
  cur: TPersonalRecord;
begin
  cur := Directory;
  try
    while cur.name <> ebName.Text do begin
      cur := cur.next;
      if nil = cur then raise ERecordNotFound.Create('Jmno ''' + ebName.Text + ''' nen v seznamu');
    end {while};
    ebAddress.Text := cur.IPAddr;
  except
    on e: ERecordNotFound do begin // deklaruje promnnou e, kter odkazuje na zachycenou vjimku
      ebAddress.Text := EmptyStr;
      ShowMessage(e.Message);
    end {on};
  end {try};
end;

procedure TFAssExc.Button5Click(Sender: TObject);
label ERecordNotFount, EndProc; { "goto" naru strukturu programu, NEM se pouvat }
var
  cur: TPersonalRecord;
begin
  cur := Directory;
  while cur.name <> ebName.Text do begin
    cur := cur.next;
    if nil = cur then goto ERecordNotFount;
  end {while};
  ebAddress.Text := cur.IPAddr;
  goto EndProc; { POZOR: na tenhle skok se NESM zapomenout, jinak se buce hlsot chyba i po sprvnm nalezen jmna v seznamu! }

ERecordNotFount:
  ebAddress.Text := EmptyStr;
  ShowMessage('Jmno ''' + ebName.Text + ''' nen v seznamu');

EndProc:
end;

//------------------------------------------------------------------------------
begin
  Directory := nil;
  TPersonalRecord.Insert('j', '123.45.67.89', Directory);
  TPersonalRecord.Insert('ty', '456.45.67.89', Directory);
  TPersonalRecord.Insert('on', '789.45.67.89', Directory);
end.
