program Equality;

{$APPTYPE CONSOLE}

uses
  SysUtils;

type

  TDuration = class
  private
    day, sec: Integer;
  public
    constructor Create(aDay, aSec: Integer);
    function Equals(o: TObject): Boolean; virtual;
  end {TDuration};

  TNanoDuration1 = class (TDuration)
  private
    nano: Integer;
  public
    constructor Create(aDay, aSec, aNano: Integer);
    function Equals(o: TObject): Boolean; override;
  end {TNanoDuration1};

  TNanoDuration2 = class (TDuration)
  private
    nano: Integer;
  public
    constructor Create(aDay, aSec, aNano: Integer);
    function Equals(o: TObject): Boolean; override;
  end {TNanoDuration2};

  TNanoDuration3 = class
  private
    d: TDuration;                                          // --- kompozice ---
    nano: Integer;
  public
    constructor Create(aDay, aSec, aNano: Integer);
    function Equals(ad: TDuration): Boolean; overload;
    function Equals(nd: TNanoDuration3): Boolean; overload;
  end {TNanoDuration3};

{ --- metody tdy Duration -------------------------------------------------- }

constructor TDuration.Create(aDay, aSec: Integer);
begin
  day := aDay;
  sec := aSec;
end {Create};

{
  Je to reflexivn, symetrick a tranzitivn relace mezi objekty Self a o.
}
function TDuration.Equals(o: TObject): Boolean;
var d: TDuration;
begin
  if not (o is TDuration) then begin
    Equals := False;
  end else begin
    d := o as TDuration;
    Equals := (d.day = day) and (d.sec = sec);
  end {if};
end {Equals};

{ --- metody tdy TNanoDuration1 -------------------------------------------- }

constructor TNanoDuration1.Create(aDay, aSec, aNano: Integer);
begin
  inherited Create(aDay, aSec);
  nano := aNano;
end {Create};

function TNanoDuration1.Equals(o: TObject): Boolean;
var nd: TNanoDuration1;
begin
  if not (o is TNanoDuration1) then begin
    Equals := False;
  end else begin
    nd := o as TNanoDuration1;
    Equals := inherited Equals(nd) and (nd.nano = Self.nano);
  end {if};
end {Equals};

{ --- metody tdy TNanoDuration2 -------------------------------------------- }

constructor TNanoDuration2.Create(aDay, aSec, aNano: Integer);
begin
  inherited Create(aDay, aSec);
  nano := aNano;
end {Create};

function TNanoDuration2.Equals(o: TObject): Boolean;
var nd: TNanoDuration2;
begin
  if not (o is TDuration) then begin
    Equals := False;
  end else if not (o is TNanoDuration2) then begin
    Equals := inherited Equals(o);
  end else begin
    nd := o as TNanoDuration2;
    Equals := inherited Equals(nd) and (nd.nano = Self.nano);
  end {if};
end {Equals};

{ --- metody tdy TNanoDuration3 -------------------------------------------- }

constructor TNanoDuration3.Create(aDay, aSec, aNano: Integer);
begin
  d := TDuration.Create(aDay, aSec);
  nano := aNano;
end {Create};

function TNanoDuration3.Equals(ad: TDuration): Boolean;
begin
  Equals := False;
end {Equals};

function TNanoDuration3.Equals(nd: TNanoDuration3): Boolean;
begin
  Equals := d.Equals(nd.d) and (nd.nano = Self.nano);
end {Equals};

{------------------------------------------------------------------------------}

var
  d: TDuration;
  nd1: TNanoDuration1;
  c,e: TNanoDuration2;
  nd3, a,b: TNanoDuration3;

begin
  { TODO -oUser -cConsole Main : Insert code here }

  d := TDuration.Create(1, 12);
  nd1 := TNanoDuration1.Create(1, 12, 123);
  writeln (d.Equals(nd1)); // True
  writeln (nd1.Equals(d)); // False - !!! nesymetrick !!!
  d.Free; nd1.Free;
  writeln;

  c := TNanoDuration2.Create(1, 12, 123);
  d := TDuration.Create(1, 12);
  e := TNanoDuration2.Create(1, 12, 999);
  writeln (c.Equals(d)); // True
  writeln (d.Equals(e)); // True
  writeln (c.Equals(e)); // False - !!! nen tranzitivn !!!
  c.Free; d.Free; e.Free;
  writeln;

  {----------------------------------------------------------------------------}

  d := TDuration.Create(1, 12);
  nd3 := TNanoDuration3.Create(1, 12, 123);
  writeln (d.Equals(nd3)); // False - !!! porovnv rzn typy (nesrovnateln), ale aspo vrac natvrdo False msto aby potal nesmysly !!!
  writeln (nd3.Equals(d)); // False
  d.Free; nd3.Free;
  writeln;

  a := TNanoDuration3.Create(1, 12, 123);
  d := TDuration.Create(1, 12);
  b := TNanoDuration3.Create(1, 12, 999);
  writeln (a.Equals(d)); // False
  writeln (d.Equals(b)); // False - !!! porovnv rzn typy (nesrovnateln), ale aspo vrac natvrdo False msto aby potal nesmysly !!!
  writeln (a.Equals(b)); // False
  a.Free; d.Free; b.Free;
  writeln;

  readln;
end {Equality}.
