program Wrapper;

{$APPTYPE CONSOLE}

uses
  SysUtils;

type

{------------------------------------------------------------------------------}

  TAdder = class
    Sum: Integer;
    constructor Create;
    procedure add(x: Integer); overload; virtual;
    procedure add(a: array of Integer); overload; virtual;
  end;

constructor TAdder.Create; begin Sum := 0; end;

procedure TAdder.add(x: Integer); begin Inc(Sum, x); end;

procedure TAdder.add(a: array of Integer);
var i: Integer;
begin
  for i := Low(a) to High(a) do add(a[i]);
end;

{------------------------------------------------------------------------------}

type

  TRegisteringAdder = class
  private
    core: TAdder;
  public
    constructor Create;
    destructor Destroy; override;
    procedure add(x: Integer); overload;
    procedure add(a: array of Integer); overload;
  end;

constructor TRegisteringAdder.Create; begin core := TAdder.Create; end;
destructor TRegisteringAdder.Destroy; begin core.Free; end;

procedure TRegisteringAdder.add(x: Integer);
begin
  Writeln(x);
  core.add(x);
end;

procedure TRegisteringAdder.add(a: array of Integer);
var i: Integer;
begin
  for i := Low(a) to High(a) do Write(a[i]:5);
  Writeln;
  core.add(a);
end;

{------------------------------------------------------------------------------}

var
  arg1: Integer = 4;
  arg2: array [1..3] of Integer = (1,2,3);
  adder: TRegisteringAdder;

begin
  { TODO -oUser -cConsole Main : Insert code here }
  adder := TRegisteringAdder.Create;
  adder.add(arg1);
  adder.add(arg2);
  adder.add(arg1);
  adder.Free;
  readln;
end.
