unit UInteger;

interface

uses
  SysUtils;

type

  { zaboxovan typ Integer }
  TInteger = class (TInterfacedObject) // automaticky zru objekt a uvoln pam, jakmile zanikne posledn reference na dotynou instanci
  private
    item: Integer;
  public
    constructor Create(value: Integer); overload;
    constructor Create(value: TInteger); overload;
    function IntegerValue: Integer;
    function Equals(x: TInteger): Boolean; overload;
    function Equals(x: Integer): Boolean; overload;
  end {TInteger};

implementation

constructor TInteger.Create(value: Integer);
begin
  inherited Create;
  item := value;
end {Create};

constructor TInteger.Create(value: TInteger);
begin
  inherited Create;
  item := value.IntegerValue;
end {Create};

function TInteger.IntegerValue: Integer;
begin
  IntegerValue := item;
end {IntegerValue};

function TInteger.Equals(x: TInteger): Boolean;
begin
  Equals := IntegerValue = x.IntegerValue;
end {Equals};

function TInteger.Equals(x: Integer): Boolean;
begin
  Equals := IntegerValue = x;
end {Equals};

end {UInteger}.
