unit UInteger;

interface

uses
  SysUtils;

type

  { interface - automatick sprva pamti v Delphi }
  IInteger = interface
    function IntegerValue: Integer;
    function Equals(x: IInteger): Boolean; overload;
    function Equals(x: Integer): Boolean; overload;
  end {IInteger};

  { zaboxovan typ Integer }
  TInteger = class (TInterfacedObject, IInteger) // automaticky zru objekt a uvoln pam, jakmile zanikne posledn reference na dotynou instanci
  private
    item: Integer;
  public
    constructor Create(value: Integer); overload;
    constructor Create(value: IInteger); overload;
    function IntegerValue: Integer;
    function Equals(x: IInteger): Boolean; overload;
    function Equals(x: Integer): Boolean; overload;
  end {TInteger};

implementation

constructor TInteger.Create(value: Integer);
begin
  inherited Create;
  item := value;
end {Create};

constructor TInteger.Create(value: IInteger);
begin
  inherited Create;
  item := value.IntegerValue;
end {Create};

function TInteger.IntegerValue: Integer;
begin
  IntegerValue := item;
end {IntegerValue};

function TInteger.Equals(x: IInteger): Boolean;
begin
  Equals := IntegerValue = x.IntegerValue;
end {Equals};

function TInteger.Equals(x: Integer): Boolean;
begin
  Equals := IntegerValue = x;
end {Equals};

end {UInteger}.
