unit UString;

interface

uses
  SysUtils;

type

  TString = class; { forward }

  { interface - automatick sprva pamti v Delphi }
  IString = interface
    function StringValue: String;
    function ToUpperCase: TString;
    function Equals(x: IString): Boolean; overload;
    function Equals(x: String): Boolean; overload;
  end {IString};

  { zaboxovan typ String }
  TString = class (TInterfacedObject, IString) // automaticky zru objekt a uvoln pam, jakmile zanikne posledn reference na dotynou instanci
  private
    item: String;
  public
    constructor Create(value: String); overload;
    constructor Create(value: IString); overload;
    function StringValue: String;
    function ToUpperCase: TString;
    function Equals(x: IString): Boolean; overload;
    function Equals(x: String): Boolean; overload;
  end {TString};

implementation

constructor TString.Create(value: String);
begin
  inherited Create;
  item := value;
end {Create};

constructor TString.Create(value: IString);
begin
  inherited Create;
  item := value.StringValue;
end {Create};

function TString.StringValue: String;
begin
  StringValue := item;
end {StringValue};

function TString.ToUpperCase: TString;
begin
  ToUpperCase := TString.Create(UpperCase(StringValue));
end {ToUpperCase};

function TString.Equals(x: IString): Boolean;
begin
  Equals := StringValue = x.StringValue;
end {Equals};

function TString.Equals(x: String): Boolean;
begin
  Equals := StringValue = x;
end {Equals};

end {UString}.
