program Cards;

{$APPTYPE CONSOLE}

uses
  SysUtils;

type

  TSuit = (Hearts, Spades, Clubs, Diamonds);
  TValue = (Ace, Two, Three, Four, Five, Six, Seven, Eight, Nine, Ten, Jack, Queen, King);

  TCard = class
  public
    function GetSuit: TSuit; virtual; abstract;
    function GetValue: TValue; virtual; abstract;
  end {TCard};

  TCard1 = class (TCard)
  private
    rep: 0..51;
  public
    constructor Create(s: TSuit; v: TValue);
    function GetSuit: TSuit; override;
    function GetValue: TValue; override;
  end {TCard1};

  TCard2 = class (TCard)
  private
    rep: 0..51;
  public
    constructor Create(s: TSuit; v: TValue);
    function GetSuit: TSuit; override;
    function GetValue: TValue; override;
  end {TCard2};

constructor TCard1.Create(s: TSuit; v: TValue); begin rep := 13 * Ord(s) + Ord(v); writeln('rep=', rep) end;
function TCard1.GetSuit: TSuit; begin Result := TSuit(rep div 13) end;
function TCard1.GetValue: TValue; begin Result := TValue(rep mod 13) end;

constructor TCard2.Create(s: TSuit; v: TValue); begin rep := 4 * Ord(v) + Ord(s); writeln('rep=', rep) end;
function TCard2.GetSuit: TSuit; begin Result := TSuit(rep mod 4) end;
function TCard2.GetValue: TValue; begin Result := TValue(rep div 4) end;

var c1: TCard1; c2: TCard2;

begin
  { TODO -oUser -cConsole Main : Insert code here }
  c1 := TCard1.Create(Clubs, Jack);
  writeln ('suit=', Ord(c1.GetSuit), ', value=', Ord(c1.GetValue));
  c2 := TCard2.Create(Clubs, Jack);
  writeln ('suit=', Ord(c2.GetSuit), ', value=', Ord(c2.GetValue));
  readln
end.
