unit UComPort;
{
  ovldn jednobitovch signl na sriovm portu funkcemi Windows API

  pouil jsem tyto ciz zdrojky:
    Petr Stehlk: PortCom (http://www.stehlik.net/portydir/portydir.htm)
    RS232 (com_io) Guide (Freeware)
      Jan Taralczak, 21 january 1997 (jtaralcz@iiic.ethz.ch)
    ComPort Library ver. 3.0
      written by Dejan Crnila, 1998 - 2002,
      maintained by Lars B. Dybdahl, 2003 (http://comport.sf.net/)

  ir 070717 vytvoeno
}

interface
uses SysUtils;

type
	Tcom = (com1, com2);
  EComPort = class(Exception);

  TComPort = class
  private
  	handle: THandle;
    procedure setSignal(signal: Cardinal);
    procedure SetDTR(x: Boolean);
    procedure SetRTS(x: Boolean);
    procedure SetTx(x: Boolean);
    function getSignal(signal: Cardinal): Boolean;
    function GetCTS: Boolean;
    function GetDSR: Boolean;
    function GetRing: Boolean;
    function GetRLSD: Boolean;
  public
    function GetSignals: Cardinal;
    property DTR: Boolean write setDTR;
    property RTS: Boolean write setRTS;
    property TxD: Boolean write setTx;
    property CTS: Boolean read getCTS;
    property DSR: Boolean read getDSR;
    property RI: Boolean read getRing;
    property RLSD: Boolean read getRLSD;
    constructor Create(port: Tcom);
    destructor Destroy; override;
  end {TComPort};

implementation

uses Windows;

const
	cport: array [Tcom] of string =('COM1:9600,N,8,1','COM2:9600,N,8,1');
  CError_OpenFailed       = 'Cannot open com port.';
  CError_EscapeComFailed  = 'EscapeCommFunction function failed.';
  CError_ModemStatFailed  = 'GetCommModemStatus function failed.';

//--------------------------------------------------------------------------//
// Otevre COM port pro dalsi pouziti
constructor TComPort.Create(port: Tcom);
begin
  inherited Create;
  handle := CreateFile(
    PChar(cport[port]),
    GENERIC_READ or GENERIC_WRITE,
    0,
    nil,
    OPEN_EXISTING,
    FILE_FLAG_OVERLAPPED,
    0);
  if handle = INVALID_HANDLE_VALUE then
    raise EComPort.Create(CError_OpenFailed);
end {Create};

//--------------------------------------------------------------------------//
// Uzavre COM port
destructor TComPort.Destroy;
begin
  if handle <> INVALID_HANDLE_VALUE then
    CloseHandle(handle);
  inherited Destroy;
end {};

//--------------------------------------------------------------------------//
// Podle predaneho parametru nastavi signal na com portu
procedure TComPort.setSignal(signal: Cardinal);
begin
  if not EscapeCommFunction(handle, signal) then
    raise EComPort.Create(CError_EscapeComFailed);
end {setSignal};

//--------------------------------------------------------------------------//
// Podle predaneho parametru nastavi DTR
procedure TComPort.SetDTR(x: Boolean);
begin
  if x then setSignal(Windows.SETDTR) else setSignal(Windows.CLRDTR);
end {SetDTR};
//--------------------------------------------------------------------------//
// Podle predaneho parametru nastavi RTS
procedure TComPort.SetRTS(x: Boolean);
begin
  if x then setSignal(Windows.SETRTS) else setSignal(Windows.CLRRTS);
end {SetRTS};

//--------------------------------------------------------------------------//
// Podle predaneho parametru nastavi TX
procedure TComPort.SetTx(x: Boolean);
begin
  if x then setSignal(Windows.SETBREAK) else setSignal(Windows.CLRBREAK);
end {SetTx};

//--------------------------------------------------------------------------//
// Nacte stav com portu
function TComPort.GetSignals: Cardinal;
var
  status: Cardinal;
begin
  if GetCommModemStatus(handle, status) then
    Result := status
  else raise EComPort.Create(CError_ModemStatFailed);
end {GetSignals};

//--------------------------------------------------------------------------//
// Nacte stav com portu
function TComPort.getSignal(signal: Cardinal): Boolean;
var
  status: Cardinal;
begin
  if GetCommModemStatus(handle, status) then
    Result := (status and signal) <> 0
  else raise EComPort.Create(CError_ModemStatFailed);
end {getSignal};

//--------------------------------------------------------------------------//
// Nacte stav vstupu CTS
function TComPort.GetCTS: Boolean;
begin
  Result := getSignal(MS_CTS_ON)
end {GetCTS};

//--------------------------------------------------------------------------//
// Nacte stav vstupu DSR
function TComPort.GetDSR: Boolean;
begin
  Result := getSignal(MS_DSR_ON)
end {GetDSR};
//--------------------------------------------------------------------------//
// Nacte stav vstupu RING
function TComPort.GetRing: Boolean;
begin
  Result := getSignal(MS_RING_ON)
end {GetRing};
//--------------------------------------------------------------------------//
// Nacte stav vstupu RLSD
function TComPort.GetRLSD: Boolean;
begin
  Result := getSignal(MS_RLSD_ON)
end {GetRLSD};
//--------------------------------------------------------------------------//

end {UComPort}.

