unit UFTeplomer;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    lblValue: TLabel;
    Label2: TLabel;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses UComPort, URunningSum;

const max = 100;

var
  cPort: TComPort;
  HiSum, PerSum: TRunningSum;

procedure TForm1.FormCreate(Sender: TObject);
begin
  HiSum := TRunningSum.Create(max);
  PerSum := TRunningSum.Create(max);
  cPort := TComPort.Create(com1);
  cPort.RTS := true; // zapni napajeni teplomeru
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  cPort.RTS := false; // vypni napajeni teplomeru
  cPort.Free;
  HiSum.Free;
  PerSum.Free;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  x, y: Int64;
begin
  repeat until not cPort.CTS; { cekej na ---\ }
  repeat until cPort.CTS;     { cekej na ---\___/ }
  QueryPerformanceCounter(x); { zacni merit }
  repeat until not cPort.CTS; { cekej na ---\___/---\ }
  QueryPerformanceCounter(y);
  HiSum.Put(y-x);
  repeat until cPort.CTS;     { cekej na ---\___/---\___/ }
  QueryPerformanceCounter(y);
  perSum.Put(y-x);
  // duty cycle = HiDur / PerDur = 0.320 + 0.00470*t (t = temperature in C)
  // i.e.: t = ((HiDur / PerDur) - 0.320) / 0.00470
  lblValue.Caption :=
    FloatToStrF((hiSum.Get / perSum.Get - 0.320) / 0.00470, ffFixed, 5, 1);
end;

end.
