unit UListQueue;

interface
uses UQueue, UElem, UMember;

type
  TListQueue = class (TQueue)
  public
    constructor Create;
    function Get: TElem; override;
    function Head: TElem; override;
    procedure Put(val: TElem); override;
    function IsEmpty: Boolean; override;
    function GetCount: Integer; override;
  private
    store, tail: TMember;
    count: Integer;
  end {TQueue};

implementation

constructor TListQueue.Create;
begin
  store := nil;
  count := 0;
end {Create};

function TListQueue.Get: TElem;
var tmp: TMember;
begin
  Get := Head;
  if not IsEmpty then begin
    tmp := store;
    store := store.next;
    tmp.elem := nil;
    tmp.Free;
    Dec(count);
  end {if};
end {Get};

function TListQueue.Head: TElem;
begin
  Head := store.elem.value;
end {Head};

procedure TListQueue.Put(val: TElem);
var tmp: TMember;
begin
  tmp := TMember.Create(val);
  if IsEmpty then begin
    store := tmp;
    tail := tmp;
    count := 1;
  end else begin
    tail.next := tmp;
    tail := tmp;
    Inc(count);
  end {if};
end {Put};

function TListQueue.IsEmpty: Boolean;
begin
  IsEmpty := store = nil;
end {IsEmpty};

function TListQueue.GetCount: Integer;
begin
  GetCount := count;
end {GetCount};

end {UQueue}.

