unit UQueue;

interface

const
  storeSize = 512;

type
  TQueue = class
    private
      store: array [0..Pred(storeSize)] of Cardinal;
      ix: Word;
      total: Cardinal;
    public
      constructor Create;
      procedure Put(x: Cardinal);
      function Sum: Cardinal;
  end {TQueue};

implementation

constructor TQueue.Create;
var i: Word;
begin
  for i := 0 to Pred(storeSize) do store[i] := 0;
  ix := 0;
  total := 0;
end {Create};

procedure TQueue.Put(x: Cardinal);
begin
  total := total - store[ix] + x;
  store[ix] := x;
  if ix < Pred(storeSize) then Inc(ix) else ix :=0; { v kruhu }
end {Put};

function TQueue.Sum: Cardinal;
begin
  Sum := total;
end {Sum};

end.
