program TraceChooseCards;

{
  Spot, kolika zpsoby lze vybrat m z n karet.

  ways(m,n) = 1   pro m = n
  ways(m,n) = n   pro m = 1
  ways(m,n) = ways(m-1,n-1) + ways(m,n-1)   pro 1 < m < n
}

{$APPTYPE CONSOLE}

uses
  SysUtils;

var
  m, n: Integer;

//---------------------------------------------------------------------

var
  Stack: array [1..100] of String;
  sp: 1..100;

procedure StartTrace; begin sp := 1 end;

procedure TraceWays(s: String); begin Stack[sp] := s; Inc(sp); end;

procedure TraceReturn(s: String);
var i: Integer;
begin
  for i := 1 to sp do Write(Stack[i]); Writeln('return ', s);
  Dec(sp);
  for i := 1 to Pred(sp) do Write(Stack[i]); Writeln;
end {TraceWays};

//---------------------------------------------------------------------

function ways(m, n: Integer): Integer;
begin
  TraceWays('ways(' + IntToStr(m) + ',' + IntToStr(n) + ') ');
  if m = n then Result := 1
  else if m = 1 then Result := n
  else Result := ways(m-1,n-1) + ways(m,n-1);
  TraceReturn(IntToStr(Result));
end {ways};

begin
  { TODO -oUser -cConsole Main : Insert code here }
  Write('m: '); Readln(m);
  Write('n: '); Readln(n);
  Assert((1 <= m) and (m <= n),'### Chyba m nebo n ###');
  StartTrace;
  Writeln;
  Writeln(ways(m, n));
  Readln;
end {ChooseCards}.
