program RecursiveCalculator;

{
  Rozebr a vyhodnocuje celoseln vrazy. Vrazy te
  ze znakovho souboru a vsledky pe tak do znakovho
  souboru.

  Text: Expression (Expression)* EOF
  Expression: Term (Operator Term)*
  Operator: "+" | "-"
  Term: Number | "(" Expression ")"
  Number: Digit (Digit)*
}

{$APPTYPE CONSOLE}

uses
  SysUtils;

const
  Trace = True;

var
  InFile, OutFile: Text;
  CurrChar: Char;

(*********************************************************************)

procedure SkipBlanks(var inf: Text);
begin
  while not Eof(inf) and (' ' >= CurrChar) do Read(inf, CurrChar);
end {SkipBlanks};

(*********************************************************************)

function ParseNumber(var inf, ouf: Text; nest: Integer): Integer;
begin
  if Trace then Writeln(ouf,#13,#10,'*** ParseNumber nest=',nest);
  Result := 0;
  while CurrChar in ['0'..'9'] do begin
    Result := 10 * Result + Ord(CurrChar) - Ord('0');
    Write(ouf,CurrChar);
    if Eof(inf)
      then CurrChar := Chr(0)
      else Read(inf, CurrChar);
  end {while};
end {ParseNumber};

(*********************************************************************)

function ParseExpression(var inf, ouf: Text; nest: Integer): Integer; forward;

function ParseTerm(var inf, ouf: Text; nest: Integer): Integer;
begin
  if Trace then Writeln(ouf,#13,#10,'*** ParseTerm nest=',nest);
  SkipBlanks(inf);
  if CurrChar in ['0'..'9'] then begin
    // parse number
    Result := ParseNumber(inf, ouf, Succ(nest));
  end else begin
    // parse "("
    Assert('(' = CurrChar,' ### Chyb "(" ### ');
    Write(ouf,'(');
    Read(inf, CurrChar);
    // parse expression
    Result := ParseExpression(inf, ouf, Succ(nest));
    SkipBlanks(inf);
    // parse ")"
    Assert(')' = CurrChar,' ### Chyb ")" ### ');
    Write(ouf,')');
    Read(inf, CurrChar);
  end {if};
  SkipBlanks(inf);
end {ParseTerm};

(*********************************************************************)

function ParseExpression(var inf, ouf: Text; nest: Integer): Integer;
begin
  if Trace then Writeln(ouf,#13,#10,'*** ParseExpression nest=',nest);
  Result := ParseTerm(inf, ouf, Succ(nest));
  while ('+' = CurrChar) or ('-' = CurrChar) do begin
    Write(ouf, CurrChar);
    if '+' = CurrChar then begin
      Read(inf, CurrChar);
      Result := Result + ParseTerm(inf, ouf, Succ(nest));
    end else begin
      Read(inf, CurrChar);
      Result := Result - ParseTerm(inf, ouf, Succ(nest));
    end {if};
  end {while};
end {ParseExpression};

(*********************************************************************)

procedure ParseText(var inf, ouf: Text; nest: Integer);
var
  result: Integer;
begin
  if Trace then Writeln(ouf,#13,#10,'*** ParseText nest=',nest);
  result := ParseExpression(inf, ouf, Succ(nest));
  Writeln(ouf, ' = ', result);
  while not Eof(inf) do begin
    result := ParseExpression(inf, ouf, Succ(nest));
    Writeln(ouf, ' = ', result);
  end {while};
  Writeln(ouf, '*** HOWGH ***');
end {ParseText};

(*********************************************************************)

begin
  { TODO -oUser -cConsole Main : Insert code here }

  AssignFile(InFile, 'expressions.txt');
  AssignFile(OutFile, 'results.txt');
  Reset(InFile);
  Rewrite(OutFile);

  Read(InFile, CurrChar);
  ParseText(InFile, OutFile, 1);

  CloseFile(InFile);
  CloseFile(OutFile);
  Writeln('*** HOWGH ***');
  Readln;
end.
