unit UHanoi;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TForm1 = class(TForm)
    shPole1: TShape;
    shPole2: TShape;
    shPole3: TShape;
    shDisc9: TShape;
    shDisc2: TShape;
    Shape2: TShape;
    Shape3: TShape;
    shDisc3: TShape;
    shDisc4: TShape;
    shDisc5: TShape;
    shDisc6: TShape;
    shDisc7: TShape;
    shDisc8: TShape;
    shDisc0: TShape;
    shDisc1: TShape;
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

function Move(fromPole, toPole: Integer): Boolean;

implementation

{$R *.dfm}

uses UEngine;

var
  tower: array [1..3, 0..9] of Integer;
  poleTop: array [1..3] of Integer;

function mustNotMove(fromPole, toPole: Integer): Boolean;
begin
  if 0 < poleTop[toPole]
    then mustNotMove := tower[toPole, pred(poleTop[toPole])] <= tower[fromPole, pred(poleTop[fromPole])]
    else mustNotMove := false
end {mustNotMove};

function disc(size: Integer): TShape;
begin
  case size of
  0: disc := Form1.shDisc0;
  1: disc := Form1.shDisc1;
  2: disc := Form1.shDisc2;
  3: disc := Form1.shDisc3;
  4: disc := Form1.shDisc4;
  5: disc := Form1.shDisc5;
  6: disc := Form1.shDisc6;
  7: disc := Form1.shDisc7;
  8: disc := Form1.shDisc8;
  else disc := Form1.shDisc9;
  end {case}
end {disc};

function leftBase(pole: Integer): Integer;
begin
  case pole of
  1: leftBase := 16;
  2: leftBase := 216;
  else leftBase := 424;
  end {case}
end {leftBase};

function Move(fromPole, toPole: Integer): Boolean;
begin
  Assert((fromPole in [1..3]) and (toPole in [1..3]), '### Wrong pole number ###');
  if 0 >= poleTop[fromPole] then Move := False
  else if mustNotMove(fromPole, toPole) then Move := False
  else begin
    Dec(poleTop[fromPole]);
    tower[toPole, poleTop[toPole]] := tower[fromPole, poleTop[fromPole]];
    with disc(tower[fromPole, poleTop[fromPole]]) do begin
      Left := leftBase(toPole) + 8 * (9 - tower[fromPole, poleTop[fromPole]]);
      Top := 168 - 16 * poleTop[toPole];
    end {with};
    Inc(poleTop[toPole]);
    Form1.Repaint;
    Sleep(Delay);
    Move := True
  end {if};
end {Move};

procedure TForm1.FormCreate(Sender: TObject);
var i: Integer;
begin
  poleTop[1] := 10;
  poleTop[2] :=  0;
  poleTop[3] :=  0;
  for i := 0 to 9 do tower[1, i] := 9 - i;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  Play;
end;

end.
