program LogCalc;

{
  Rozebr a vyhodnocuje celoseln vrazy. Vrazy te
  ze znakovho souboru a vsledky pe tak do znakovho
  souboru.

  Text: Expression (Expression)* EOF
  Expression: Term (Operator Term)*
  Operator: "+" | "-"
  Term: Number | "(" Expression ")"
  Number: Digit (Digit)*
}

{$APPTYPE CONSOLE}

uses
  SysUtils,
  TextLog in 'TextLog.pas';

var
  CurrChar: Char;

(*********************************************************************)

procedure SkipBlanks(nest: Integer);
begin
  WriteLog(nest, 'SkipBlanks', 'start');
  while not Eoln and (' ' >= CurrChar) do Read(CurrChar);
  WriteLog(nest, 'SkipBlanks', 'done');
end {SkipBlanks};

(*********************************************************************)

function ParseNumber(nest: Integer): Integer;
begin
  WriteLog(nest, 'ParseNumber', 'start');
  Result := 0;
  while CurrChar in ['0'..'9'] do begin
    Result := 10 * Result + Ord(CurrChar) - Ord('0');
    Write(CurrChar);
    if Eoln
      then CurrChar := Chr(0)
      else Read(CurrChar);
  end {while};
  WriteLog(nest, 'ParseNumber', 'result = ' + IntToStr(Result) + ', done');
end {ParseNumber};

(*********************************************************************)

function ParseExpression(nest: Integer): Integer; forward;

function ParseTerm(nest: Integer): Integer;
begin
  WriteLog(nest, 'ParseTerm', 'start');
  SkipBlanks(nest);
  if CurrChar in ['0'..'9'] then begin
    // parse number
    Result := ParseNumber(Succ(nest));
  end else begin
    // parse "("
    WriteLog(nest, 'ParseTerm', 'checking ''(''=' + CurrChar);
    Assert('(' = CurrChar,' ### Chyb "(" ### ');
    Write('(');
    Read(CurrChar);
    // parse expression
    Result := ParseExpression(Succ(nest));
    SkipBlanks(nest);
    // parse ")"
    WriteLog(nest, 'ParseTerm', 'checking '')''=' + CurrChar);
    Assert(')' = CurrChar,' ### Chyb ")" ### ');
    Write(')');
    Read(CurrChar);
  end {if};
  SkipBlanks(nest);
  WriteLog(nest, 'ParseTerm', 'result = ' + IntToStr(Result) + ', done');
end {ParseTerm};

(*********************************************************************)

function ParseExpression(nest: Integer): Integer;
begin
  WriteLog(nest, 'ParseExpression', 'start');
  Result := ParseTerm(Succ(nest));
  while ('+' = CurrChar) or ('-' = CurrChar) do begin
    Write(CurrChar);
    if '+' = CurrChar then begin
      Read(CurrChar);
      Result := Result + ParseTerm(Succ(nest));
      WriteLog(nest, 'ParseExpression', 'result = ' + IntToStr(Result) + ', add');
    end else begin
      Read(CurrChar);
      Result := Result - ParseTerm(Succ(nest));
      WriteLog(nest, 'ParseExpression', 'result = ' + IntToStr(Result) + ', sub');
    end {if};
  end {while};
  WriteLog(nest, 'ParseExpression', 'result = ' + IntToStr(Result) + ', done');
end {ParseExpression};

(*********************************************************************)

procedure ParseText(nest: Integer);
var
  result: Integer;
begin
  WriteLog(nest, 'ParseText', 'start');
  result := ParseExpression(Succ(nest));
  Writeln(' = ', result);
  WriteLog(nest, 'ParseText', 'result = ' + IntToStr(result) + ', done');
end {ParseText};

(*********************************************************************)

begin
  { TODO -oUser -cConsole Main : Insert code here }

  RewriteLog;
  Read(CurrChar);
  ParseText(1);
  CloseLog;
  Readln;
  Readln;
end.
