unit StreamLog;
{ prce s logem implementovanm jako stream }
{ ir 070423 - vytvoeno }

{----------------------------------------------------------------------}

interface

procedure ResetLog; { oteve log pro ten }
procedure RewriteLog; { oteve log pro psan }
procedure CloseLog; { zave log }
function  ReadLog: String; { pete jeden zznam z logu }
procedure WriteLog(aNest: Integer; aProc, aMesg: String); { zape jeden zznam do logu }
function  EofLog: Boolean; { true pi dosaen konce logu, jinak false }

{----------------------------------------------------------------------}

implementation
uses SysUtils, Classes;

const

  LogFN = 'logfile.stream'; { jmno logovacho souboru }

type

  { typ zznamu pro logovn }
  TLogRec = record
    ordn: Integer;    { poadov slo zznamu }
    when: TDateTime;  { datum a as, kdy dojde k zpisu }
    nest: Integer;    { rove vnoen volajc rutiny }
    proc: String[16]; { jmno volajc rutiny }
    mesg: String[24]; { zprva, kter m bt zapsna do logu }
  end {TLogRec};

var

  OrdNr: Integer; { poadov slo zznamu v logu }
  LogStream: TFileStream;

{ oteve log pro ten }
procedure ResetLog;
begin
  LogStream := TFileStream.Create(LogFN, fmOpenRead);
end {ResetLog};

{ oteve log pro psan }
procedure RewriteLog;
begin
  LogStream := TFileStream.Create(LogFN, fmCreate or fmOpenWrite);
  OrdNr := 0;
end {RewriteLog};

{ zave log }
procedure CloseLog;
begin
  LogStream.Free;
end {CloseLog};

{
  el:
    pete jeden zznam z logu
  vrac:
    obsah jednoho zznamu zformtovan do znakovho etzce
}
function ReadLog: String;
var
  rec: TLogRec;
begin
  LogStream.Read(rec, SizeOf(rec));
  with rec do Result := Format('%4d | %18s | %4d | %16s | %21s', [ordn, DateTimeToStr(when), nest, proc, mesg]);
end {ReadLog};

{
  el:
    zape jeden zznam do logu
  parametry:
    nest     - rove vnoen volajc rutiny
    procname - jmno volajc rutiny
    msg      - zprva, kter m bt zapsna do logu
}
procedure WriteLog(aNest: Integer; aProc, aMesg: String);
var
  rec: TLogRec;
begin
  Inc(OrdNr);
  with rec do begin
    ordn := OrdNr;
    when := Now;
    nest := aNest;
    proc := aProc;
    mesg := aMesg;
  end {with};
  LogStream.Write(rec, SizeOf(rec));
end {WriteLog};

{
  el:
    indikuje konec logu
  vrac:
    true pi dosaen konce logu, jinak false
}
function  EofLog: Boolean;
begin
  EofLog := LogStream.Position >= LogStream.Size;
end {EofLog};

end {StreamLog}.
