unit UnitHangman;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls;

type
  TFormHangman = class(TForm)
    btnA: TButton;
    btnB: TButton;
    btnC: TButton;
    btnD: TButton;
    btnE: TButton;
    btnF: TButton;
    btnG: TButton;
    btnH: TButton;
    btnI: TButton;
    btnJ: TButton;
    btnK: TButton;
    btnL: TButton;
    btnM: TButton;
    btnN: TButton;
    btnO: TButton;
    btnP: TButton;
    btnQ: TButton;
    btnR: TButton;
    btnS: TButton;
    btnT: TButton;
    btnU: TButton;
    btnV: TButton;
    btnW: TButton;
    btnX: TButton;
    btnY: TButton;
    btnZ: TButton;
    sgCrossword: TStringGrid;
    Label1: TLabel;
    ebMax: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure btnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormHangman: TFormHangman;

implementation

{$R *.dfm}

uses UPuzzle;

var
  Puzzle: TPuzzle;
  max, guesses: Integer;

procedure TFormHangman.btnClick(Sender: TObject);
begin
  try
    if 0 > max then max := StrToInt(ebMax.Text);
    Puzzle.Highlight((Sender as TButton).Caption[1]);
    Puzzle.Display;
    Inc(guesses);
    if Puzzle.Solved then begin
      ShowMessage('Vyhrla/vyhrl jsi po ' + IntToStr(guesses) + ' pokusech');
      Application.Terminate;
    end else if guesses >= max then begin
      ShowMessage('Prohrla/prohrl jsi po ' + IntToStr(guesses) + ' pokusech');
      Application.Terminate;
    end {if};
  except on Exception do
    ShowMessage('Max. poet pokus m bt slo.');
  end {try};
end;

procedure TFormHangman.FormCreate(Sender: TObject);
begin
  Puzzle := TPuzzle.Create('hangman.txt', sgCrossword);
end;

begin
  max := -1;
  guesses := 0;
end.
