unit UTraceStack;
// Zsobnk, kter zaznamenv voln a nvraty funkc
// ir 070610

interface
uses UStack;

// Zaznamenv voln a nvraty funkc
type TTraceStack = class (TStack)
  private
    traceFile: Text;
  public
    constructor Create(maxDepth: Integer);
    procedure Close;
    procedure Display;
    procedure Extend(name: String);
    procedure Reduce(value: Integer);
end {TTraceStack};

implementation

(*********************************************************************)

constructor TTraceStack.Create(maxDepth: Integer);
begin
  inherited Create(maxDepth);
  AssignFile(traceFile,'trace.txt');
  Rewrite(traceFile);
end {Create};

(*********************************************************************)

// Zave trasovac soubor
procedure TTraceStack.Close;
begin
  CloseFile(traceFile);
end {Close};

(*********************************************************************)

// Vype obsah zsobnku do trasovacho souboru
procedure TTraceStack.Display;
var i: Integer;
begin
  for i := Low(table) to Pred(depth) do begin
    Write(traceFile, table[i], ' ');
  end {for};
end {Display};

(*********************************************************************)

// Trasuje voln funkce
// Popis:
//  Vlo jmno funkce do zsobnku a zape je tak do trasovacho souboru.
// Parametr:
//  name - jmno funkce
procedure TTraceStack.Extend(name: String);
begin
  Push(name);
  Write(traceFile, name, ' ');
end {Extend};

(*********************************************************************)

// Trasuje nvrat z funkce
// Popis:
//  Zape funkn hodnotu do trasovacho souboru. Vyjme jmno funkce
//  ze zsobnku. Zape obsah zsobnku do trasovacho souboru.
// Parametr:
//  value - funkn hodnota, kterou vrt trasovan funkce
procedure TTraceStack.Reduce(value: Integer);
begin
  Writeln(traceFile, 'return ', value);
  Pop;
  Display;
  Writeln(traceFile);
  Display;
end {Reduce};

(*********************************************************************)

end {UTraceStack}.
