unit UMap;
{
  ir 070612 - vytvoeno
}

interface
uses UCity;

type
  TMap = class
    protected
      grid: array of array of Integer;
      s: Integer;
    public
      constructor Create(var inFile: Text);
      procedure NewMap(route: array of TCity; n: Integer);
      procedure Write(var outFile: Text);
  end {TMap};

implementation

constructor TMap.Create(var inFile: Text);
var i, j: Integer;
begin
  readln(inFile, s);
  SetLength(grid, s, s);
  for i := Low(grid) to High(grid) do begin
    for j := Low(grid[i]) to High(grid[i]) do begin
      read(inFile, grid[i,j]);
    end {for};
    readln(inFile);
  end {for};
end {Create};

procedure TMap.NewMap(route: array of TCity; n: Integer);
var i, j, k: Integer;
begin
  for k := Low(route) to High(route) do begin
    i := route[k].x;
    j := route[k].y;
    grid[i,j] := Succ(k); { slovn mst zan od 1, indexovn od 0 }
  end {for};
end {NewMap};

procedure TMap.Write(var outFile: Text);
var i, j: Integer;
begin
  for i := Low(grid) to High(grid) do begin
    for j := Low(grid[i]) to High(grid[i]) do begin
      System.Write(outFile, grid[i,j]:3);
    end {for};
    Writeln(outFile);
  end {for};
  Writeln(outFile);
end {Write};

end {UMap}.
