unit UTour;
{
  ir 070612 - vytvoeno
}

interface
uses UMap, UCity;

type
  TTour = class (TMap)
    private
      route: array of TCity;
      n: Integer;
      procedure exchange(i, j: Integer);
    public
      constructor Create(var inFile: Text);
      function Length: Integer;
      procedure Write(var outFile: Text);
      procedure Shorten;
  end {TTour};

implementation

constructor TTour.Create(var inFile: Text);
var i, j, k: Integer;
begin
  inherited Create(inFile);
  n := s * s;
  SetLength(route, n);
  for i := Low(grid) to High(grid) do begin
    for j := Low(grid[i]) to High(grid[i]) do begin
      k := Pred(grid[i,j]); { slovn mst zan od 1, indexovn od 0 }
      route[k] := TCity.Create(i, j);
    end {for};
  end {for};
end {Create};

procedure TTour.exchange(i, j: Integer);
var ri, rj: TCity;
begin
  ri := route[i].Copy;
  rj := route[j].Copy;
  route[i] := rj;
  route[j] := ri;
end {exchange};

function TTour.Length: Integer;
var k: Integer;
begin
  Result := UCity.Distance(route[High(route)], route[Low(route)]);
  for k := Low(route) to High(route)-1 do begin
    Result := Result + UCity.Distance(route[k], route[Succ(k)]);
  end {for};
end {Length};

procedure TTour.Write(var outFile: Text);
begin
  inherited Write(outFile);
  Writeln(outFile, 'length ', Length);
  Writeln(outFile);
end {Write};

procedure TTour.Shorten;
var i, j, k, min, next: Integer;
begin
  Randomize; { in 0..n-1 }
  min := Length;
  for k := 1 to 1000 * n do begin
    i := Random(n); { in 0..n-1 }
    j := Random(n); { in 0..n-1 }
    exchange(i, j);
    next := Length;
    if (next <= min)
      then min := next
      else exchange(i, j); { zptky }
  end {for};
  NewMap(route, n);
end {Shorten};

end {UTour}.
