unit Decoder;
{
  dekodr znak pro sedmisegmentov displej
  ry 070102
}

interface

type

  { vet jednotlivch segment displeje }
  TSegment = (
    sgUpLeft, sgLowLeft, sgTop, sgCenter, sgBottom, sgUpRight, sgLowRight
  );

  { mnoina segment displeje }
  TDisplay = set of TSegment;


{ dekduje znak c na mnoinu segment sedmisegmentovho displeje }
function Decode(c: Char): TDisplay;

implementation

{
  Dekduje znak c na mnoinu segment sedmisegmentovho displeje.
  Parametr:
    c - znak, kter se m dekdovat
  Vrac:
    mnoinu segment sedmisegmentovho displeje
}
function Decode(c: Char): TDisplay;
begin
  case c of
  ' ':
    Decode := [];

  { ### Cvien: dekdujte slice '0' a '9' ### }

  'E':
    Decode := [sgUpLeft, sgLowLeft, sgTop, sgCenter, sgBottom];
  else
    case ord(c) mod 10 of
    0:
      Decode := [sgUpLeft, sgTop];
    1:
      Decode := [sgTop, sgUpRight];
    2:
      Decode := [sgUpRight, sgCenter];
    3:
      Decode := [sgCenter, sgLowLeft];
    4:
      Decode := [sgLowLeft, sgBottom];
    5:
      Decode := [sgBottom, sgLowRight];
    6:
      Decode := [sgLowRight, sgCenter];
    7:
      Decode := [sgLowRight, sgCenter, sgUpLeft];
    8:
      Decode := [sgCenter, sgUpLeft];
    else
      Decode := [sgCenter, sgUpLeft, sgTop];
    end {case};
  end {case}
end {Decode};

end {Decoder}.
