unit UnitHangman;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls;

type
  TFormHangman = class(TForm)
    btnA: TButton;
    btnB: TButton;
    btnC: TButton;
    btnD: TButton;
    btnE: TButton;
    btnF: TButton;
    btnG: TButton;
    btnH: TButton;
    btnI: TButton;
    btnJ: TButton;
    btnK: TButton;
    btnL: TButton;
    btnM: TButton;
    btnN: TButton;
    btnO: TButton;
    btnP: TButton;
    btnQ: TButton;
    btnR: TButton;
    btnS: TButton;
    btnT: TButton;
    btnU: TButton;
    btnV: TButton;
    btnW: TButton;
    btnX: TButton;
    btnY: TButton;
    btnZ: TButton;
    sgCrossword: TStringGrid;
    Label1: TLabel;
    ebMax: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure btnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormHangman: TFormHangman;

implementation

{$R *.dfm}

var
  data: Text;
  n, max, guesses: Integer;
  crossword: array of array of Char;

procedure TFormHangman.btnClick(Sender: TObject);
var
  i, j: Integer;
  ch: Char;
  known: Integer;
begin
  try
    if 0 > max then max := StrToInt(ebMax.Text);
    ch := (Sender as TButton).Caption[1];
    known := 0;
    for i := Low(crossword) to High(crossword) do begin
      for j := Low(crossword) to High(crossword) do begin
        if UpCase(crossword[j,i]) = UpCase(ch) then begin
          sgCrossword.Cells[j,i] := ch;
          sgCrossword.Refresh;
        end {if};
        if '?' <> sgCrossword.Cells[j,i] then Inc(known);
      end {for};
    end {for};
    Inc(guesses);
    if n * n = known then begin
      ShowMessage('Vyhrla/vyhrl jsi po ' + IntToStr(guesses) + ' pokusech');
      Application.Terminate;
    end else if guesses >= max then begin
      ShowMessage('Prohrla/prohrl jsi po ' + IntToStr(guesses) + ' pokusech');
      Application.Terminate;
    end {if};
  except on Exception do
    ShowMessage('Max. poet pokus m bt slo.');
  end {try};
end;

procedure TFormHangman.FormCreate(Sender: TObject);
var
  i, j: Integer;
  ch: Char;
begin
  AssignFile(data, 'hangman.txt');
  Reset(data);
  Readln(data, n);
  SetLength(crossword, n, n);
  sgCrossword.Height := 27 * n;
  sgCrossword.Width  := 27 * n;
  sgCrossword.ColCount := n;
  sgCrossword.RowCount := n;
  for i := Low(crossword) to High(crossword) do begin
    for j := Low(crossword) to High(crossword) do begin
      Read(data, ch);
      crossword[j,i] := ch;
      if '.' = ch
        then sgCrossword.Cells[j,i] := '.'
        else sgCrossword.Cells[j,i] := '?';
    end {for};
    Readln(data);
  end {for};
  CloseFile(data);
end;

begin
  max := -1;
  guesses := 0;
end.
