program Spreadsheet;
{
  Nate, post a vype tabulku nklad na pozen a provoz malho auta,
  kter najezd 100 000 mil bhem 10 let.

  Vstupn soubor sestv z deseti dek, kad dka pro jeden rok. Kad
  dka uruje rok, ujet mle, provozn nklady a vlastnick nklady za
  rok.

  Program nate vstupn data do celoseln matice a spot odpovdajc
  sloupcov a dkov souty. Tabulku pak zape i se zhlavm sloupc.
}

{$APPTYPE CONSOLE}

uses
  SysUtils;

const
  m = 11;
  n = 5;

type
  TTable = array [1..m, 1..n] of Integer;

var
  inFile, outFile: Text;
  i, j: Integer;
  table: TTable;

{ nati tabulku }
function ReadSheet(var aFile: Text): TTable;
var
  lTable: TTable;
  i, j: Integer;
begin
  for i := 1 to m-1 do
    for j := 1 to n-1 do
      Read(aFile, lTable[i, j]);
  ReadSheet := lTable;
end {ReadSheet};

{ seti dky }
function RowSum (const aTable: TTable; i, first, last: Integer): Integer;
var
  sum, j: Integer;
begin
  sum := 0;
  for j := first to last do begin
    sum := sum + table[i, j];
  end {for};
  RowSum := sum;
end {RowSum};

{ seti sloupce }
function ColumnSum (const aTable: TTable; j, first, last: Integer): Integer;
var
  sum, i: Integer;
begin
  sum := 0;
  for i := first to last do begin
    sum := sum + table[i, j];
  end {for};
  ColumnSum := sum;
end {ColumnSum};

{ vypi tabulku }
procedure WriteSheet(var aFile: Text; const aTable: TTable);
var
  i, j: Integer;
begin
  Writeln(aFile, '"Year";"Miles";"Operating Costs";"Owning Costs";"Total Driven Costs"');
  for i := 1 to m-1 do begin
    Write(aFile, aTable[i, 1]);
    for j := 2 to n do begin
      Write(aFile, '; ', aTable[i, j]);
    end {for};
    Writeln(aFile);
  end {for};
  Write(aFile, '"1979-88"');
  for j := 2 to n do begin
    Write(aFile, '; ', aTable[m, j]);
  end {for};
  Writeln(aFile);
end {WriteSheet};

begin
  { TODO -oUser -cConsole Main : Insert code here }

  { naten dat }
  AssignFile(inFile, 'data.txt');
  AssignFile(outFile, 'results.csv');
  Reset(inFile);
  Rewrite(outFile);

  { nati tabulku }
  table := ReadSheet(inFile);

  { seti dky }
  for i := 1 to m-1 do begin
    table[i, n] := RowSum(table, i, 3, n-1);
  end {for};

  { seti sloupce }
  for j := 2 to n do begin
    table[m, j] := ColumnSum(table, j, 1, m-1);
  end {for};

  { vypi tabulku }
  WriteSheet(outFile, table);

  CloseFile(inFile);
  CloseFile(outFile);
  Write('***   H O W G H   ***'); Readln;

end.
