program Lecture2;

{$APPTYPE CONSOLE}

uses
  SysUtils;

type

//------------------------------------------------------------------------------
//   objekt s vystavenmi datovmi leny
//------------------------------------------------------------------------------

  Trans = class
    amount: Integer; // primitivn typ
    date: TDateTime; // pejmenovan primitivn typ Double (tj. Real)
  end {Trans};

//------------------------------------------------------------------------------
//   objekt se skrytmi datovmi leny
//------------------------------------------------------------------------------

  Trans2 = class
  private
    amount: Integer; // primitivn typ
    date: TDateTime; // pejmenovan primitivn typ Double (tj. Real)
  public
    constructor Create(a: Integer);
    function Save(a: Integer): Integer;
    function Withdraw(a: Integer): Integer;
    function ToString: String;
  end {Trans2};

  constructor Trans2.Create(a: Integer); // zalo et s potenm vkladem a
  begin
    amount := a;
    date := Now;
  end {Create};

  function Trans2.Save(a: Integer): Integer; // ulo na et stku a
  begin
    amount := amount + a;
    date := Now;
    Save := amount;
  end {Create};

  function Trans2.Withdraw(a: Integer): Integer; // vybere z tu stku a
  begin
    amount := amount - a;
    date := Now;
    Withdraw := amount;
  end {Create};

  function Trans2.ToString: String; // zjist stav tu v iteln podob
  begin
    ToString := IntToStr(amount) + ' on ' + DateTimeToStr(date);
  end {ToString};

//------------------------------------------------------------------------------

var
  a, b: String;
  t, u: Trans;
  t2: Trans2;

begin
  { TODO -oUser -cConsole Main : Insert code here }

//------------------------------------------------------------------------------
//   Promnn, odkazy a etzce
//------------------------------------------------------------------------------

  writeln('1. Variables, References and Strings');
  writeln;

  a := 'zeeb';
  b := UpperCase(a);
  writeln('a=''', a, ''', a refers to ', Cardinal(a)); // petypovn odkazu na nezporn cel slo
  writeln('b=''', b, ''', b refers to ', Cardinal(b));
  write('b contains a reference to another instance of string'); readln;
  writeln;

  a := 'zeeb';
  writeln('a=''', a, ''', a refers to ', Cardinal(a));
  UpperCase(a);
  writeln('a=''', a, ''', a refers to ', Cardinal(a));
  write('UpperCase doesn''t mutate the string'); readln;
  writeln;

  a := 'zeeb';
  writeln('a=''', a, ''', a refers to ', Cardinal(a));
  a := UpperCase(a);
  writeln('a=''', a, ''', a refers to ', Cardinal(a));
  write('Another instance of string is referenced by the a variable now'); readln;
  writeln;

//------------------------------------------------------------------------------

  writeln;
  writeln('2. Aliasing, Mutability and Reference Equality of Objects');
  writeln;

  t := Trans.Create;
  u := t;
  if u = t
    then write('same')
    else write('different');
  readln;
  writeln('Assignment of t to u has made the both variables equal. No surprise so far...'); readln;
  t.Free;

  t := Trans.Create;
  u := t;
  t.amount := 111; t.date := Now;
  writeln('t.amount=', t.amount, ', t.date=', DateTimeToStr(t.date));
  u.amount := 222; u.date := Now + 1.0;
  writeln('t.amount=', t.amount, ', t.date=', DateTimeToStr(t.date));
  writeln('u.amount=', u.amount, ', u.date=', DateTimeToStr(u.date));
  writeln('Assignment to the u variable has changed the value of the t variable. Why?'); readln;
  t.Free;

  t := Trans.Create;
  u := Trans.Create;
  if u = t
    then write('same')
    else write('different');
  readln;
  writeln('Two fresh instances differ. Why?'); readln;
  t.Free;
  u.Free;

  t := Trans.Create;
  u := Trans.Create;
  t.amount := 333; t.date := Now;
  u.amount := t.amount; u.date := t.date;
  writeln('t.amount=', t.amount, ', t.date=', DateTimeToStr(t.date));
  writeln('u.amount=', u.amount, ', u.date=', DateTimeToStr(u.date));
  if u = t
    then write('same')
    else write('different');
  readln;
  write('Two istances containing the same values differ. Why?'); readln;
  write('Let''s see more details:'); readln;
  writeln('t.amount=', t.amount, ', t.date=', DateTimeToStr(t.date), ', t refers to ', Cardinal(t));
  writeln('u.amount=', u.amount, ', u.date=', DateTimeToStr(u.date), ', u refers to ', Cardinal(u));
  writeln('The two variables refer to different instances.');
  writeln('Values of the instances don''t matter.'); readln;
  t.Free;
  u.Free;

//------------------------------------------------------------------------------

  writeln;
  writeln('3. Null References');
  writeln;

  a := EmptyStr;
  write('a=''', a, ''', a refers to ', Cardinal(a)); readln;
  b := UpperCase(a);
  write('b=''', b, ''', b refers to ', Cardinal(b)); readln;

  t := nil;
  write('t refers to ', Cardinal(t)); readln;

  try
    t := nil;
    t.amount := 20;
    write(t.amount);
  except on e: Exception do
    begin
      write('EXCEPTION RAISED: ' + e.Message);
    end
  end;
  readln;

//------------------------------------------------------------------------------

  writeln;
  writeln('4. User Defined Classes and Fields');
  writeln;

  t := Trans.Create;
  t.amount := 444; // do datov poloky amount mohu nastavit libovolnou hodnotu
  t.date := StrToDateTime('8.11.1620 13:30'); // do datov poloky date mohu nastavit libovoln datum nezvisle na okamiku zmny poloky amount
  write('amount = ', t.amount, ', date = ', DateTimeToStr(t.date)); readln;
  t.Free;

  t2 := Trans2.Create(555); // datum se nastav automaticky sprvn
  write(t2.ToString); readln;
  t2.Save(222); // uloenou stku lze mnit jenom dovolenm zpsobem a datum se nastav automaticky
  write(t2.ToString); readln;
  t2.Withdraw(111); // druh ze dvou dovolench zpsob, jak zmnit stku
  write(t2.ToString); readln;
  t2.Free;

  writeln;
  writeln('---   The End   ---');
  readln;
end {Lecture2}.
