unit UDate;

interface

uses
  SysUtils;

type

  { interface IDateTime - automatick sprva pamti v Delphi }
  IDate = interface
    function TDateTimeValue: TDateTime;
    function Equals(x: IDate): Boolean; overload;
    function Equals(x: TDateTime): Boolean; overload;
  end {IDate};

  { zaboxovan typ TDateTime }
  TDate = class (TInterfacedObject, IDate) // automaticky zru objekt a uvoln pam, jakmile zanikne posledn reference na dotynou instanci
  private
    item: TDateTime;
  public
    constructor Create(); overload;
    constructor Create(value: TDateTime); overload;
    constructor Create(value: IDate); overload;
    function TDateTimeValue: TDateTime;
    function Equals(x: IDate): Boolean; overload;
    function Equals(x: TDateTime): Boolean; overload;
  end {TDate};

implementation

constructor TDate.Create;
begin
  inherited Create;
  item := Now;
end {Create};

constructor TDate.Create(value: TDateTime);
begin
  inherited Create;
  item := value;
end {Create};

constructor TDate.Create(value: IDate);
begin
  inherited Create;
  item := value.TDateTimeValue;
end {Create};

function TDate.TDateTimeValue: TDateTime;
begin
  TDateTimeValue := item;
end {TDateTimeValue};

function TDate.Equals(x: IDate): Boolean;
begin
  Equals := TDateTimeValue = x.TDateTimeValue;
end {Equals};

function TDate.Equals(x: TDateTime): Boolean;
begin
  Equals := TDateTimeValue = x;
end {Equals};

end {UDate}.
