program Bank;

{$APPTYPE CONSOLE}

uses
  SysUtils, Contnrs;

type

  TTrans = class
    amount: Integer;
    date: TDateTime;
    constructor Create(a: Integer; d: TDateTime);
  end {TTrans};

  TAccount = class
    name: String;
    transv: TObjectList;
    balance: Integer;
    constructor Create(n: String);
    function checkTrans(t: TTrans): Boolean; virtual;
    procedure post(t: TTrans);
    function postTemplate(t: TTrans): Boolean;
  end {TAccount};

  TAccountPlus = class(TAccount)
    creditLimit: Integer;
    constructor Create(n: String; c: Integer);
    function checkTrans(t: TTrans): Boolean; override;
  end {TAccountPlus};

  TBank = class
    accounts: array of TAccount;
    constructor Create;
    procedure chargeMonthlyFee;
  end {TBank};

//-------------------------------------------------
//  TTrans

constructor TTrans.Create(a: Integer; d: TDateTime);
begin
  amount := a;
  date := d;
end {Create};

//-------------------------------------------------
//  TAccount

constructor TAccount.Create(n: String);
begin
  transv := TObjectList.Create(true);
  balance := 0;
  name := n;
end {Create};

function TAccount.checkTrans(t: TTrans): Boolean;
begin
  writeln('TAccount.checkTrans: amount=', t.amount, ', balance=', balance);
  checkTrans := ((balance + t.amount) >= 0);
end {checkTrans};

procedure TAccount.post(t: TTrans);
begin
  writeln('TAccount.post: amount=', t.amount, ', balance=', balance);
  transv.Add(t);
  Inc(balance, t.amount);
end {post};

function TAccount.postTemplate(t: TTrans): Boolean;
begin
  writeln('TAccount.post: amount=', t.amount, ', balance=', balance);
  Result := checkTrans(t);
  if Result then begin
    transv.Add(t);
    Inc(balance, t.amount);
  end {if};
end {postTemplate};

//-------------------------------------------------
//  TAccountPlus

constructor TAccountPlus.Create(n: String; c: Integer);
begin
  inherited Create(n);
  creditLimit := c;
end {Create};

function TAccountPlus.checkTrans(t: TTrans): Boolean;
begin
  writeln('TAccountPlus.checkTrans: amount=', t.amount, ', balance=', balance, ', creditLimit=', creditLimit);
  checkTrans := ((balance + creditLimit + t.amount) >= 0);
end {checkTrans};

//-------------------------------------------------
//  TBank

constructor TBank.Create;
begin
    SetLength(accounts, 3);
    accounts[0] := TAccountPlus.Create('Franta', 101);
    accounts[1] := TAccount.Create('Tonda');
    accounts[2] := TAccountPlus.Create('Pepa', 102);
end {Create};

procedure TBank.chargeMonthlyFee;
var i: Integer; fee: TTrans;
begin
  for i := Low(accounts) to High(accounts) do begin
    fee := TTrans.Create(-1, Date);
    if accounts[i].checkTrans(fee) then accounts[i].post(fee);
  end {for};
end {chargeMonthlyFee};

//-------------------------------------------------

var
  accp: TAccountPlus;
  acc: TAccount;
  t: TTrans;
  b: TBank;
begin
  { TODO -oUser -cConsole Main : Insert code here }

  accp := TAccountPlus.Create('Zork', 100);
  t := TTrans.Create(100, Date);
  if accp.checkTrans(t) then accp.post(t);
  writeln('balance=', accp.balance);
  writeln;

  acc := TAccountPlus.Create('Zork', 100);
  t := TTrans.Create(100, Date);
  if acc.checkTrans(t) then acc.post(t);
  writeln('balance=', acc.balance);
  writeln;

  b := TBank.Create;
  b.chargeMonthlyFee;

  accp := TAccountPlus.Create('Zork', 100);
  writeln('post=', accp.postTemplate(TTrans.Create(-50, Date)));
  writeln('balance=', accp.balance);

  readln;
end.
