program ProcType;

{$APPTYPE CONSOLE}

uses
  SysUtils;

//---------------------------------------------------------------------------
// 1. parametr typu procedure
//---------------------------------------------------------------------------

type
  procMesic = procedure(x: integer);

procedure anglicky (x: integer);
begin
  case x of
  1: write('January');
  2: write('February');
  3: write('March');
  4: write('April');
  5: write('May');
  6: write('June');
  7: write('July');
  8: write('August');
  9: write('September');
  10: write('October');
  11: write('November');
  12: write('December');
  end {case};
end {anglicky};

procedure nemecky (x: integer);
begin
  case x of
  1: write('Januar');
  2: write('Februar');
  3: write('Maerz');
  4: write('April');
  5: write('Mai');
  6: write('Juni');
  7: write('Juli');
  8: write('August');
  9: write('September');
  10: write('Oktober');
  11: write('November');
  12: write('Dezember');
  end {case};
end {nemecky};

procedure napisDatumParam(pisMesicParam: procMesic);
var year, month, day: Word;
begin
  DecodeDate(Date, year, month, day);
  write(day,'. ');
  pisMesicParam(month);
  write(' ',year)
end {napisDatumParam};

//---------------------------------------------------------------------------
// 2. promenna typu procedure
//---------------------------------------------------------------------------

var
  pisMesicVar: procMesic;

procedure napisDatumVar;
var year, month, day: Word;
begin
  DecodeDate(Date, year, month, day);
  write(day, '. ');
  pisMesicVar(month);
  write(' ', year)
end {napisDatumVar};

//---------------------------------------------------------------------------
// 3. atribut typu procedure
//---------------------------------------------------------------------------

type
  todayAtrClass = class
    pisMesicAtr: procMesic;
    constructor Create;
    procedure napisDatumAtr;
  end {todayAtrClass};

  heuteAtrClass = class (todayAtrClass)
    constructor Create;
  end {heuteAtrClass};

constructor todayAtrClass.Create;
begin
  inherited;
  pisMesicAtr := anglicky;
end {Create};

constructor heuteAtrClass.Create;
begin
  inherited;
  pisMesicAtr := nemecky;
end {Create};

procedure todayAtrClass.napisDatumAtr;
var year, month, day: Word;
begin
  DecodeDate(Date, year, month, day);
  write(day,'. ');
  pisMesicAtr(month);
  write(' ',year)
end {napisDatumAtr};

var
  atrClass: todayAtrClass;

//---------------------------------------------------------------------------
// 4. virtualni procedura
//---------------------------------------------------------------------------

type
  todayVirtClass = class
    procedure pisMesicVirt(x: integer); virtual;
    procedure napisDatumVirt;
  end {todayVirtClass};

  heuteVirtClass = class (todayVirtClass)
    procedure pisMesicVirt(x: integer); override;
  end {heuteVirtClass};

procedure todayVirtClass.pisMesicVirt(x: integer);
begin
  anglicky(x);
end {pisMesicVirt};

procedure heuteVirtClass.pisMesicVirt(x: integer);
begin
  nemecky(x);
end {pisMesicVirt};

procedure todayVirtClass.napisDatumVirt;
var year, month, day: Word;
begin
  DecodeDate(Date, year, month, day);
  write(day,'. ');
  pisMesicVirt(month);
  write(' ',year)
end {napisDatumVirt};

var
  virtClass: todayVirtClass;

//---------------------------------------------------------------------------

begin
  { TODO -oUser -cConsole Main : Insert code here }

  // 1. parametr typu procedure
  //-------------------------------------------------------------------------
  writeln('1. parametr typu procedure');
  napisDatumParam(anglicky);
  writeln;
  napisDatumParam(nemecky);
  writeln;

  // 2. promenna typu procedure
  //-------------------------------------------------------------------------
  writeln;
  writeln('2. promenna typu procedure');
  pisMesicVar := anglicky;
  napisDatumVar;
  writeln;
  pisMesicVar := nemecky;
  napisDatumVar;
  writeln;

  // 3. atribut typu procedure
  //-------------------------------------------------------------------------
  writeln;
  writeln('3. atribut typu procedure');
  atrClass := todayAtrClass.Create;
  atrClass.napisDatumAtr;
  atrClass.Free;
  writeln;

  atrClass := heuteAtrClass.Create;
  atrClass.napisDatumAtr;
  atrClass.Free;
  writeln;

  // 4. virtualni procedura
  //-------------------------------------------------------------------------
  writeln;
  writeln('4. virtualni procedura');
  virtClass := todayVirtClass.Create;
  virtClass.napisDatumVirt;
  virtClass.Free;
  writeln;

  virtClass := heuteVirtClass.Create;
  virtClass.napisDatumVirt;
  virtClass.Free;
  writeln;

  //-------------------------------------------------------------------------
  readln;
end.
