unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    txtSvNazev: TEdit;
    gbSvazek: TGroupBox;
    gbKniha: TGroupBox;
    gbCasopis: TGroupBox;
    txtKnNazev: TEdit;
    txtKnAutor: TEdit;
    txtCaNazev: TEdit;
    txtCaRocnik: TEdit;
    btnSvazek: TButton;
    btnKniha: TButton;
    btnCasopis: TButton;
    btnUkaz: TButton;
    procedure btnUkazClick(Sender: TObject);
    procedure btnCasopisClick(Sender: TObject);
    procedure btnKnihaClick(Sender: TObject);
    procedure btnSvazekClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//--------------------------------------

type

  TSvazek = class
    Nazev: String;
    function DejZaznam: String; virtual;
    procedure UkazZaznam;
  end;

  TKniha = class (TSvazek)
    Autor: String;
    function DejZaznam: String; override;
  end;

  TCasopis = class (TSvazek)
    Rocnik: String;
    function DejZaznam: String; override;
  end;

var
  svazek: TSvazek;

procedure TSvazek.UkazZaznam;
begin
  ShowMessage(DejZaznam);
end {UkazZaznam};

function TSvazek.DejZaznam: String;
begin
  DejZaznam := Nazev
end {DejZaznam};

function TKniha.DejZaznam: String;
begin
  DejZaznam := Autor + ':' + #$0D + Nazev
end {DejZaznam};

function TCasopis.DejZaznam: String;
begin
  DejZaznam := Nazev + #$0D + '(' + Rocnik + ')'
end {DejZaznam};

//--------------------------------------

procedure TForm1.btnSvazekClick(Sender: TObject);
begin
  if nil <> svazek then svazek.Free;
  svazek := TSvazek.Create;
  svazek.Nazev := txtSvNazev.Text
end;

procedure TForm1.btnKnihaClick(Sender: TObject);
begin
  if nil <> svazek then svazek.Free;
  svazek := TKniha.Create;
  svazek.Nazev := txtKnNazev.Text;
  TKniha(svazek).Autor := txtKnAutor.Text
end;

procedure TForm1.btnCasopisClick(Sender: TObject);
begin
  if nil <> svazek then svazek.Free;
  svazek := TCasopis.Create;
  svazek.Nazev := txtCaNazev.Text;
  TCasopis(svazek).Rocnik := txtCaRocnik.Text
end;

procedure TForm1.btnUkazClick(Sender: TObject);
begin
  if nil = svazek then
    ShowMessage('Naped vytvo njak svazek!')
  else
    svazek.UkazZaznam
end;

begin
  svazek := nil;
end.
