unit URunningSum;

interface
uses UElem, UQueue;

type
  TRunningSum = class
    constructor Create(maxCount: Integer);
    function Get: TElem;
    procedure Put(val: TElem);
  private
    sum: TElem;
    que: TQueue;
    max: Integer;
  end {TRunningSum};

implementation

uses UListQueue; // #####

constructor TRunningSum.Create(maxCount: Integer);
begin
  sum := 0;
  que := TListQueue.Create; // #####
  max := maxCount;
end;

function TRunningSum.Get: TElem;
begin
  Get := sum;
  if max <= que.GetCount then Dec (sum, que.Get);
end;

procedure TRunningSum.Put(val: TElem);
begin
  Inc (sum, val);
  que.Put(val);
end;

end {TRunningSum}.
